<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFarmerBusinesPlansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('farmer_busines_plans', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('crop',65);
            $table->string('default_yield',65);
            $table->string('variety',65);
            $table->double('market_price',10,2);
            $table->double('profit',10,2);
            $table->integer('farmer_id')->unsigned();
            $table->timestamps();
            //foreigns
            $table->foreign('farmer_id')->references('id')->on('farmers')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('farmer_busines_plans', function (Blueprint $table) {
            $table->dropForeign('farmer_id');
            // $table->dropForeign('parent_id');
        });
        Schema::dropIfExists('farmer_busines_plans');
    }
}
