<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLivestocksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('livestocks', function (Blueprint $table) {
            $table->bigIncrements('livestock_id');
            $table->string('animal',100);
            $table->string('breed',100);
            $table->string('sex',10);
            $table->double('weight',10,2);
            $table->double('age',10,2);
            $table->string('disease_history',100);
            $table->string('purpose',100);
            $table->string('intake',100);
            $table->string('yields',100);
            $table->integer('tag_number')->length(100)->unsigned();
            $table->integer('agent_id')->unsigned();
            $table->integer('farmer_id')->unsigned();
            $table->bigInteger('parent_id')->unsigned()->nullable();
            //foreigns
            $table->foreign('farmer_id')->references('id')->on('farmers')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('parent_id')->references('livestock_id')->on('livestocks')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->timestamps();
        });
    }

/**
 * Reverse the migrations.
 *
 * @return void
 */
public function down()
{
    Schema::table('livestocks', function (Blueprint $table) {
        $table->dropForeign('farmer_id');
        // $table->dropForeign('parent_id');
    });
        Schema::dropIfExists('livestocks');
    }
}
