<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Query\Expression;

class CreateEventsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('events', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->string('title');
            $table->text('description')->nullable();
            $table->timestamp('start');
            $table->timestamp('end')->nullable();
            $table->string('classNames');
            $table->bigInteger('farmer_id')->nullable()->unsigned();
            $table->integer('agent_id')->nullable()->unsigned();
            $table->timestamps();
            //foreigns
            $table->foreign('farmer_id')->references('id')->on('farmers')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('agent_id')->references('agent_id')->on('agents')->onUpdate('CASCADE')->onDelete('RESTRICT');
            });
    }

    /**
    * Reverse the migrations.
    *
    * @return void
    */
    public function down()
    {
        Schema::table('events', function (Blueprint $table) {
            $table->dropForeign('farmer_id');
            $table->dropForeign('agent_id');
        });
        Schema::dropIfExists('events');
    }
}
