<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIVRSTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('i_v_r_s', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->longText('message');
            $table->string('audio',255);
            $table->integer('status')->length(1)->default(0)->unsigned();
            $table->integer('farmer_id')->unsigned();
            $table->integer('agent_id')->unsigned();
            $table->string('sessionId',255)->nullable();
            $table->timestamps();
            //foreigns
            $table->foreign('farmer_id')->references('id')->on('farmers')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

/**
 * Reverse the migrations.
 *
 * @return void
 */
public function down()
{
    Schema::table('i_v_r_s', function (Blueprint $table) {
        $table->dropForeign('farmer_id');
    });
        Schema::dropIfExists('i_v_r_s');
    }
}
