<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePicturesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pictures', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('soil_health_id')->unsigned();
            $table->string('picture_name',255);
            $table->timestamps();
            //foreigns 
            $table->foreign('soil_health_id')->references('soil_health_id')->on('farmer_soil_healths')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('pictures', function(Blueprint $table) {
            $table->dropForeign('soil_health_id');
        });
        Schema::dropIfExists('pictures');
    }
}
