<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCropCalendarsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('crop_calendars', function (Blueprint $table) {
            $table->bigIncrements('crop_calendar_id');
            $table->string('event_type',65);
            $table->string('specific_activity',255);
            $table->string('date_time',25);
            $table->integer('status')->length(1)->default(0)->unsigned();
            $table->longText('comments');
            $table->integer('farmer_id')->unsigned();
            $table->timestamps();
            //foreigns
            $table->foreign('farmer_id')->references('id')->on('farmers')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('crop_calendars', function (Blueprint $table) {
            $table->dropForeign('farmer_id');
        });
        Schema::dropIfExists('crop_calendars');
    }
}
