<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCropSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('crop_settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('crop',65);
            $table->string('default_yield',65);
            $table->string('variety',65);
            $table->string('region',65);
            $table->string('planting_method',65);
            $table->double('cost_of_production',10,2);
            $table->double('market_price',10,2);
            $table->double('profit',10,2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('crop_settings');
    }
}
