<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAdditionalSeasonalProducesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('additional_seasonal_produces', function (Blueprint $table) {
            $table->bigIncrements('additional_id');
            $table->bigInteger('season_produce_id')->unsigned();
            $table->longText('other_details');
            $table->timestamps();
            //foreigns
            $table->foreign('season_produce_id')->references('season_produce_id')->on('season_produces')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('additional_seasonal_produces', function (Blueprint $table) {
            $table->dropForeign('season_produce_id');
        });
        Schema::dropIfExists('additional_seasonal_produces');
    }
}
