<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSeasonProducesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('season_produces', function (Blueprint $table) {
            $table->bigIncrements('season_produce_id');
            $table->integer('produce_item_id')->unsigned();
            $table->bigInteger('season_id')->unsigned();
            $table->string('quality',25);
            $table->string('recommended_seed',100);
            $table->string('fertilizer',100);
            $table->string('pesticides',100);
            $table->string('sowing_date',25);
            $table->string('sowing_area',65);
            $table->string('yield_estimation',100);
            $table->string('est_harvestdate',25);
            $table->timestamps();
            //foreigns
            $table->foreign('produce_item_id')->references('id')->on('produce_items')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('season_id')->references('season_id')->on('seasons')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('season_produces', function (Blueprint $table) {
            $table->dropForeign('produce_item_id');
            $table->dropForeign('season_id');
        });
        Schema::dropIfExists('season_produces');
    }
}
