<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSeasonsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('seasons', function (Blueprint $table) {
            $table->bigIncrements('season_id');
            $table->string('season',255);
            $table->integer('year')->length(4)->unsigned();
            $table->integer('farmer_id')->unsigned();
            $table->timestamps();
            //foreigns
            $table->foreign('farmer_id')->references('id')->on('farmers')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

/**
 * Reverse the migrations.
 *
 * @return void
 */
public function down()
{
    Schema::table('seasons', function (Blueprint $table) {
        $table->dropForeign('farmer_id');
    });
        Schema::dropIfExists('seasons');
    }
}
