<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFarmerSoilHealthsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('farmer_soil_healths', function (Blueprint $table) {
            $table->bigIncrements('soil_health_id');
            $table->string('pictures',500);
            $table->string('geolocation',255);
            $table->string('physical',255);
            $table->string('chemical',255);
            $table->string('biological',255);
            $table->string('biometric',255);
            $table->integer('farmer_id')->unsigned();
            $table->timestamps();
            //foreigns
            $table->foreign('farmer_id')->references('id')->on('farmers')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('farmer_soil_healths', function (Blueprint $table) {
            $table->dropForeign('farmer_id');
        });
        Schema::dropIfExists('farmer_soil_healths');
    }
}
