<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInputReleasesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('input_releases', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('input_order_item_id')->unsigned();
            $table->string('picked_by', 65)->nullable();
            $table->string('id_no', 10)->nullable();
            $table->string('phone', 15)->nullable();
            $table->timestamps();

            $table->foreign('input_order_item_id','trading_input_order_item_id_foreign')->references('id')->on('input_order_items')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('input_releases', function (Blueprint $table) {
            $table->dropForeign('trading_input_order_item_id_foreign');
        });
        Schema::dropIfExists('input_releases');
    }
}
