<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInputOrderItemsForwardedTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('input_order_items_forwarded', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->integer('input_order_item_id')->unsigned();
            $table->integer('forwarded_by')->unsigned();
            $table->integer('forwarded_to')->unsigned();
            $table->timestamps();

            $table->foreign('input_order_item_id','trading_input_order_items_forwarded_input_order_item_id_foreign')->references('id')->on('input_order_items')->onUpdate('CASCADE')->onDelete('CASCADE');
            // $table->foreign('forwarded_by','trading_input_order_items_forwarded_forwarded_by_foreign')->references('id')->on('trader')->onUpdate('CASCADE')->onDelete('RESTRICT');
            // $table->foreign('forwarded_to','trading_input_order_items_forwarded_forwarded_to_foreign')->references('id')->on('trader')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('input_order_items_forwarded', function (Blueprint $table) {
            $table->dropForeign('trading_input_order_items_forwarded_input_order_item_id_foreign');
            // $table->dropForeign('trading_input_order_items_forwarded_forwarded_by_foreign');
            // $table->dropForeign('trading_input_order_items_forwarded_forwarded_to_foreign');
        });

        Schema::dropIfExists('input_order_items_forwarded');
    }
}
