<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTraderNetworksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trader_networks', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->integer('trader_id')->unsigned();
            $table->integer('agrodealer_id')->unsigned();
            $table->enum('type', ['national', 'regional', 'last-mile']);
            $table->integer('region_id')->unsigned()->nullable();
            $table->integer('county_id')->unsigned()->nullable();
            $table->text('description')->nullable();
            $table->unique(['trader_id','agrodealer_id']);
            $table->timestamps();

            $table->foreign('trader_id','trading_trader_networks_trader_id_foreign')->references('id')->on('traders')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign('agrodealer_id','trading_trader_networks_agrodealer_id_foreign')->references('id')->on('traders')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign('region_id','trading_trader_networks_region_id_foreign')->references('id')->on('regions')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign('county_id','trading_trader_networks_county_id_foreign')->references('id')->on('counties')->onUpdate('CASCADE')->onDelete('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('trader_networks', function (Blueprint $table) {
            $table->dropForeign('trading_trader_networks_trader_id_foreign');
            $table->dropForeign('trading_trader_networks_agrodealer_id_foreign');
            $table->dropForeign('trading_trader_networks_region_id_foreign');
            $table->dropForeign('trading_trader_networks_county_id_foreign');
        });

        Schema::dropIfExists('trader_networks');
    }
}
