<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCreditTransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('credit_transactions', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->integer('credit_id')->unsigned();
            $table->decimal('amount',13,2);
            $table->timestamps();

            $table->foreign('credit_id','trading_credits_credits_id_foreign')->references('id')->on('credits')->onUpdate('CASCADE')->onDelete('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('credit_transactions', function (Blueprint $table) {
            $table->dropForeign('trading_credits_credits_id_foreign');
        });
        Schema::dropIfExists('credit_transactions');
    }
}
