<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInputDeliveryConfirmsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('input_delivery_confirms', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->string('comment',255);
            $table->integer('input_order_items_release_id')->unsigned();
            $table->integer('trader_id')->unsigned();
            $table->string('state_of_arrival',65);
            $table->timestamps();

            $table->foreign('trader_id','trading_input_delivery_confirms_trader_id_foreign')->references('id')->on('traders')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('input_order_items_release_id','trading_input_delivery_confirms_release_id_foreign')->references('id')->on('input_order_items_releases')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('input_delivery_confirms', function (Blueprint $table) {
            $table->dropForeign('trading_input_delivery_confirms_trader_id_foreign');
            $table->dropForeign('trading_input_delivery_confirms_release_id_foreign');
        });
        Schema::dropIfExists('input_delivery_confirms');
    }
}
