<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTrigger6 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::unprepared('
        CREATE TRIGGER `addCreditReq` AFTER INSERT ON `trading_input_order_items`
        FOR EACH ROW IF NEW.financing = "credit"
        THEN
        INSERT INTO trading_credits SET
        trading_credits.user_id = NEW.farmer_id,
        trading_credits.input_order_item_id = NEW.id,
        trading_credits.requested_amount = NEW.price,
        trading_credits.created_at = NEW.created_at;
        END IF
        ');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::unprepared('DROP TRIGGER `addCreditReq`');
    }
}
