<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCreditClearingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('credit_clearings', function (Blueprint $table) {
            $table->integerIncrements('id');
            $table->integer('credit_id')->unsigned();
            $table->decimal('amount',13,4)->unsigned();
            $table->string('source',25)->nullable();
            $table->timestamps();

            $table->foreign('credit_id','trading_credits_id_foreign')->references('id')->on('credits')->onUpdate('CASCADE')->onDelete('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('credit_clearings', function (Blueprint $table) {
            $table->dropForeign('trading_credits_id_foreign');
        });
        Schema::dropIfExists('credit_clearings');
    }
}
