<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Query\Expression;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class CreateCreditsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('credits', function (Blueprint $table) {
            $database = DB::connection("mysql_lms")->getDatabaseName();

            $table->integerIncrements('id')->unsigned();
            $table->integer('user_id');
            $table->integer('input_order_item_id')->unsigned();
            $table->decimal('requested_amount',13,4);
            $table->decimal('credited_amount',13,4)->nullable();
            $table->decimal('payable_amount',13,4)->nullable();
            $table->decimal('balance',13,4)->nullable();
            $table->integer('period')->nullable();
            $table->decimal('interest',13,4)->nullable();
            $table->integer('approved')->default(0);
            $table->integer('cleared')->default(0);
            $table->timestamps();

            $table->foreign('user_id','trading_credits_user_id_foreign')->references('id')->on(new Expression($database . '.user'))->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign('input_order_item_id','trading_credits_input_order_item_id_foreign')->references('id')->on('input_order_items')->onUpdate('CASCADE')->onDelete('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('credits', function (Blueprint $table) {
            $table->dropForeign('trading_credits_user_id_foreign');
            $table->dropForeign('trading_credits_input_order_item_id_foreign');
        });
        Schema::dropIfExists('credits');
    }
}
