<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Query\Expression;
use Illuminate\Support\Facades\DB;

class CreateFarmersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('farmers', function (Blueprint $table) {
            $database = DB::connection("mysql_lms")->getDatabaseName();

            $table->integerIncrements('id')->unsigned();
            $table->integer('user_id');
            $table->string('middlename')->nullable();
            $table->string('national_id')->nullable();
            $table->string('mpesa_number')->nullable();
            $table->string('education_level')->nullable();
            $table->string('acreage')->nullable();
            $table->string('acreage_farmed')->nullable();
            $table->text('activities')->nullable();
            $table->string('activities_crops')->nullable();
            $table->string('activities_livestock')->nullable();
            $table->string('input_spending')->nullable();
            $table->string('preferred_learning_language')->nullable();
            $table->string('preferred_agrodealer')->nullable();
            $table->text('preferred_inputs')->nullable();
            $table->text('phone_owned')->nullable();
            $table->boolean('computer_access')->default(0)->nullable();
            $table->text('computer_access_location')->nullable();
            $table->boolean('internet_access')->default(0)->nullable();
            $table->text('internet_access_location')->nullable();
            $table->boolean('credit_history')->default(0)->nullable();
            $table->boolean('credit_history_outstanding')->default(0)->nullable();
            $table->text('credit_history_outstanding_details')->nullable();
            $table->string('credit_needs')->nullable();
            $table->timestamps();

            $table->foreign('user_id','trading_farmers_user_id_foreign')->references('id')->on(new Expression($database . '.user'))->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('farmers', function (Blueprint $table) {
            $table->dropForeign('trading_farmers_user_id_foreign');
        });

        Schema::dropIfExists('farmers');
    }
}
