<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTraderInputSellersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trader_input_sellers', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->integer('trader_id')->unsigned();
            $table->boolean('extension_program')->default(0);
            $table->text('credit_providers')->nullable();
            $table->timestamps();

            $table->foreign('trader_id','trading_trader_input_sellers_trader_id_foreign')->references('id')->on('traders')->onUpdate('CASCADE')->onDelete('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('trader_input_sellers', function (Blueprint $table) {
            $table->dropForeign('trading_trader_input_sellers_trader_id_foreign');
        });

        Schema::dropIfExists('trader_input_sellers');
    }
}
