<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTraderLocalAggregatorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trader_local_aggregators', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->integer('trader_id')->unsigned();
            $table->string('storage_capacity')->nullable();
            $table->text('assets')->nullable();
            $table->boolean('computer_access')->default(0);
            $table->text('computer_access_location')->nullable();
            $table->boolean('internet_access')->default(0);
            $table->text('internet_access_location')->nullable();
            $table->string('credit_needs')->nullable();
            $table->timestamps();

            $table->foreign('trader_id','trading_trader_local_aggregators_trader_id_foreign')->references('id')->on('traders')->onUpdate('CASCADE')->onDelete('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('trader_local_aggregators', function (Blueprint $table) {
            $table->dropForeign('trading_trader_local_aggregators_trader_id_foreign');
        });

        Schema::dropIfExists('trader_local_aggregators');
    }
}
