<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTraderFarmerOrganisationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trader_farmer_organisations', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->integer('trader_id')->unsigned();
            $table->boolean('input_buying')->default(0);
            $table->string('input_buying_volume')->nullable();
            $table->string('input_buying_value')->nullable();
            $table->text('input_buying_reason')->nullable();
            $table->text('input_buying_preference')->nullable();
            $table->boolean('produce_selling')->default(0);
            $table->string('produce_selling_volume')->nullable();
            $table->text('produce_selling_reason')->nullable();
            $table->boolean('produce_selling_contracts')->default(0);
            $table->text('produce_selling_preference')->nullable();
            $table->timestamps();

            $table->foreign('trader_id','trading_trader_farmer_organisations_trader_id_foreign')->references('id')->on('traders')->onUpdate('CASCADE')->onDelete('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('trader_farmer_organisations', function (Blueprint $table) {
            $table->dropForeign('trading_trader_farmer_organisations_trader_id_foreign');
        });

        Schema::dropIfExists('trader_farmer_organisations');
    }
}
