<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTraderSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trader_settings', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->integer('trader_id')->unsigned();
            $table->double('locked');
            $table->double('credit_limit');
            $table->timestamps();

            $table->foreign('trader_id','trading_trader_settings_trader_id_foreign')->references('id')->on('traders')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('trader_settings', function (Blueprint $table) {
            $table->dropForeign('trading_trader_settings_trader_id_foreign');
        });

        Schema::dropIfExists('trader_settings');
    }
}
