<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInputOrderItemsReleasesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('input_order_items_releases', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->string('recipient',65); //who picked
            $table->string('means',65); //means of transport was picked
            $table->dateTime('date'); //datetime picked
            $table->integer('order_id')->unsigned(); //order id
            $table->integer('trader_id')->unsigned(); //trader id
            $table->integer('status')->default(1); //status 1- released, 2- received
            $table->timestamps();

            $table->foreign('order_id','trading_input_order_items_releases_order_id_foreign')->references('id')->on('input_orders')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('trader_id','trading_input_order_items_releases_trader_id_foreign')->references('id')->on('traders')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('input_order_items_releases', function (Blueprint $table) {
            $table->dropForeign('trading_input_order_items_releases_order_id_foreign');
            $table->dropForeign('trading_input_order_items_releases_trader_id_foreign');
        });
        Schema::dropIfExists('input_order_items_releases');
    }
}
