<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTrigger5 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::unprepared('
        CREATE TRIGGER `float_balance` AFTER INSERT ON `trading_input_order_items`
        FOR EACH ROW UPDATE trading_user_wallets.float_bal SET 
        trading_user_wallets.float_bal = trading_user_wallets.float_bal - NEW.price
        WHERE trading_user_wallets.user_id=NEW.farmer_id
        ');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::unprepared('DROP TRIGGER `float_balance`');
    }
}
