<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDeliveryAcknowledgementsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('delivery_acknowledgements', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->string('comment',255);
            $table->integer('delivery_id')->unsigned();
            $table->integer('trader_id')->unsigned();
            $table->string('state_of_arrival',65);
            $table->timestamps();

            $table->foreign('trader_id','trading_acknowledging_trader_id_foreign')->references('id')->on('traders')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('delivery_id','trading_acknowledging_delivery_id_foreign')->references('id')->on('deliveries')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('delivery_acknowledgements');
    }
}
