<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDeliveryRequestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('delivery_requests', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->integer('produce_collection_id')->nullable()->unsigned();
            $table->integer('transporter_id')->nullable()->unsigned();
            $table->dateTime('picking_time');
            $table->dateTime('delivery_time');
            $table->integer('from_id')->nullable();
            $table->integer('to_id')->nullable();
            $table->boolean('status')->default('0');
            $table->timestamps();

            $table->foreign('produce_collection_id','trading_delivery_requests_produce_collection_id_foreign')->references('id')->on('produce_orders')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('transporter_id','trading_delivery_requests_trader_id_foreign')->references('id')->on('traders')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });

        Schema::table('deliveries', function($table) {
            $table->foreign('delivery_request_id','trading_deliveries_request_id_foreign')->references('id')->on('delivery_requests')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('deliveries', function($table) {
            $table->dropForeign('trading_deliveries_request_id_foreign');
        });

        Schema::table('delivery_requests', function($table) {
            $table->dropForeign('trading_delivery_requests_produce_collection_id_foreign');
            $table->dropForeign('trading_delivery_requests_trader_id_foreign');
        });

        Schema::dropIfExists('delivery_requests');
    }
}
