<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTrigger4 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::unprepared('
        CREATE TRIGGER `releaseActors` AFTER UPDATE ON `trading_deliveries`
        FOR EACH ROW IF NEW.status = 2
        THEN UPDATE trading_vehicles SET trading_vehicles.status = 0
        WHERE trading_vehicles.id = NEW.vehicle_id;
        UPDATE trading_drivers SET trading_drivers.status = 0
        WHERE trading_drivers.id = NEW.driver_id;
        END IF
        ');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::unprepared('DROP TRIGGER `releaseActors`');
    }
}
