<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTrigger extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::unprepared('
        
        CREATE TRIGGER `updateWallet` AFTER UPDATE ON `trading_input_order_items` FOR EACH ROW IF NEW.approved = 2 
        THEN UPDATE trading_user_wallets SET
        trading_user_wallets.balance = trading_user_wallets.balance-NEW.price
        WHERE trading_user_wallets.user_id = NEW.farmer_id;
        END IF
        ');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::unprepared('DROP TRIGGER `updateWallet`');
    }
}
