<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDeliveriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('deliveries', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->integer('driver_id')->nullable()->unsigned();
            $table->integer('vehicle_id')->nullable()->unsigned();
            $table->integer('produce_order_id')->nullable()->unsigned();
            $table->integer('delivery_request_id')->nullable()->unsigned();
            $table->boolean('status')->default('0');
            $table->timestamps();

            $table->foreign('driver_id','trading_deliveries_driver_id_foreign')->references('id')->on('drivers')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('vehicle_id','trading_deliveries_vehicle_id_foreign')->references('id')->on('vehicles')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('produce_order_id','trading_deliveries_produce_collection_id_foreign')->references('id')->on('produce_collections')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('deliveries', function (Blueprint $table) {
            $table->dropForeign('trading_deliveries_driver_id_foreign');
            $table->dropForeign('trading_deliveries_vehicle_id_foreign');
            $table->dropForeign('trading_deliveries_produce_collection_id_foreign');
        });

        Schema::dropIfExists('deliveries');
    }
}
