<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Query\Expression;

class CreateDriversTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('drivers', function (Blueprint $table) {
            $database = DB::connection("mysql_lms")->getDatabaseName();

            $table->integerIncrements('id')->unsigned();
            $table->integer('trader_id')->unsigned();
            $table->string('firstname', 65)->nullable();
            $table->string('lastname', 65)->nullable();
            $table->string('email', 65)->nullable();
            $table->string('phone', 15)->nullable();
            $table->integer('user_id')->nullable();
            $table->string('licence_no', 65);
            $table->string('driver_class', 65);
            $table->boolean('status')->default('0');
            $table->integer('experience')->nullable()->unsigned();
            $table->timestamps();

            $table->foreign('trader_id','trading_trader_driver_trader_id_foreign')->references('id')->on('traders')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('user_id','trading_trader_driver_user_id_foreign')->references('id')->on(new Expression($database . '.user'))->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('drivers');
    }
}
