<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVehiclesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vehicles', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->string('make', 65);
	        $table->string('model', 65);
	        $table->double('tonnage', 13,4);
            $table->string('plate', 65);
            $table->string('description', 255)->nullable();
            $table->boolean('status')->default('0');
	        $table->integer('trader_id')->unsigned();
            $table->timestamps();

            $table->foreign('trader_id', 'trading_vehicle_trader_id_foreign')->references('id')->on('traders')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicles');
    }
}
