<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Query\Expression;

class CreateProduceCollectionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('produce_collections', function (Blueprint $table) {
            $database = DB::connection("mysql_lms")->getDatabaseName();

            $table->integerIncrements('id')->unsigned();
            $table->integer('contract_detail_id')->unsigned();
            $table->double('quantity',13,4);
            $table->boolean('status');
            $table->integer('collected_by');
            $table->integer('approved_by');
            $table->timestamps();

            $table->foreign('contract_detail_id', 'trading_produce_collections_contract_detail_id_foreign')->references('id')->on('contract_details')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('collected_by', 'trading_produce_collections_collected_by_foreign')->references('id')->on(new Expression($database . '.user'))->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('approved_by', 'trading_produce_collections_approved_by_foreign')->references('id')->on(new Expression($database . '.user'))->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('produce_collections', function(Blueprint $table) {
            $table->dropForeign('trading_produce_collections_contract_detail_id_foreign');
            $table->dropForeign('trading_produce_collections_collected_by_foreign');
            $table->dropForeign('trading_produce_collections_approved_by_foreign');
        });

        Schema::dropIfExists('produce_collections');
    }
}
