<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInvoicePaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
	{
		Schema::create('invoice_payments', function(Blueprint $table)
		{
			$table->integerIncrements('id')->unsigned();
			$table->integer('invoice_id')->unsigned();
			$table->string('mode')->nullable();
			$table->decimal('amount', 13, 4)->unsigned()->nullable();
			$table->string('reference')->nullable();
            $table->dateTime('date')->nullable();
            $table->timestamps();

			$table->foreign('invoice_id', 'trading_invoice_payments_invoice_id_foreign')->references('id')->on('invoices')->onUpdate('CASCADE')->onDelete('RESTRICT');
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('invoice_payments', function(Blueprint $table)
		{
			$table->dropForeign('trading_invoice_payments_invoice_id_foreign');
		});

		Schema::drop('invoice_payments');
	}
}
