<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->integer('input_item_id')->unsigned()->nullable();
            $table->integer('produce_collection_id')->unsigned()->nullable();
            $table->integer('number')->nullable();
            $table->string('direction'); //invoice sent to twalisha(in), invoice sent by twalisha(out)
            $table->decimal('total',13,4)->unsigned()->nullable();
            $table->decimal('balance',13,4)->unsigned()->nullable();
            $table->string('status')->nullable();
            $table->string('type',10)->nullable();
            $table->integer('directed_to')->unsigned()->nullable();
            $table->integer('posted_by');
            $table->timestamp('date')->nullable();
            $table->timestamps();

            $table->foreign('input_item_id','trading_invoices_input_item_id_foreign')->references('id')->on('input_order_items')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('produce_collection_id','trading_invoices_produce_collection_id_foreign')->references('id')->on('produce_collections')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('directed_to','trading_invoices_directed_to_foreign')->references('id')->on('traders')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('invoices', function(Blueprint $table) {
            $table->dropForeign('trading_invoices_input_item_id_foreign');
            $table->dropForeign('trading_invoices_directed_to_foreign');
            $table->dropForeign('trading_invoices_produce_collection_id_foreign');
        });

        Schema::dropIfExists('invoices');
    }
}
