<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProduceOrderItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('produce_order_items', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->integer('produce_order_id')->unsigned();
            $table->integer('contract_id')->unsigned();
            $table->decimal('price_per_unit', 13, 4);
            $table->integer('quantity');
            $table->dateTime('expected_date')->nullable();
            $table->text('description')->nullable();
            $table->boolean('approved')->default(0);
            $table->timestamps();

            $table->foreign('produce_order_id','trading_produce_order_items_produce_order_id_foreign')->references('id')->on('produce_orders')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('contract_id','trading_produce_order_items_contract_id_foreign')->references('id')->on('trader_contracts')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('produce_order_items', function (Blueprint $table) {
            $table->dropForeign('trading_produce_order_items_produce_order_id_foreign');
            $table->dropForeign('trading_produce_order_items_contract_id_foreign');
        });

        Schema::dropIfExists('produce_order_items');
    }
}
