<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Query\Expression;


class CreateProduceOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('produce_orders', function (Blueprint $table) {
            $database = DB::connection("mysql_lms")->getDatabaseName();

            $table->integerIncrements('id')->unsigned();
            $table->integer('trader_id')->unsigned();
            $table->boolean('approved')->default(0);
            $table->integer('approved_by')->nullable();
            $table->double('total',13,4)->default(0);
            $table->timestamps();

            $table->foreign('trader_id','trading_produce_orders_trader_id_foreign')->references('id')->on('traders')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('approved_by','trading_produce_orders_approved_by_foreign')->references('id')->on(new Expression($database . '.user'))->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('produce_orders', function (Blueprint $table) {
            $table->dropForeign('trading_produce_orders_trader_id_foreign');
            $table->dropForeign('trading_produce_orders_approved_by_foreign');
        });

        Schema::dropIfExists('produce_orders');
    }
}
