<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Query\Expression;
class CreateInputOrderItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('input_order_items', function (Blueprint $table) {
            $database = DB::connection("mysql_lms")->getDatabaseName();

            $table->integerIncrements('id')->unsigned();
            $table->integer('order_id')->unsigned();
            $table->integer('farmer_id');
            $table->integer('input_item_id')->unsigned();
            $table->integer('quantity');
            $table->dateTime('expected_date')->nullable();
            $table->text('description')->nullable();
            $table->integer('directed_to')->unsigned()->nullable();
            $table->string('financing',11); //mode of financing payment of input order. Either wallet or credit
            $table->double('price',8,2);
            $table->boolean('approved')->default(0); //0-Pending,1-in process,2-Processed.   Orders that need financing are placed as pending
            $table->timestamps();

            $table->foreign('order_id','trading_input_order_items_order_id_foreign')->references('id')->on('input_orders')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign('input_item_id','trading_input_order_items_input_id_foreign')->references('id')->on('input_items')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('farmer_id','trading_input_order_items_farmer_id_foreign')->references('id')->on(new Expression($database . '.user'))->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('directed_to','trading_input_order_trader_id_foreign')->references('id')->on('traders')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('input_order_items', function (Blueprint $table) {
            $table->dropForeign('trading_input_order_items_order_id_foreign');
            $table->dropForeign('trading_input_order_items_input_id_foreign');
            $table->dropForeign('trading_input_order_items_farmer_id_foreign');
            $table->dropForeign('trading_input_order_trader_id_foreign');
        });
        Schema::dropIfExists('input_order_items');
    }
}
