<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserWalletTransactions extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_wallet_transactions', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->decimal('amount', 13, 4);
            $table->string('hash', 60);
            $table->string('type', 30);
            $table->json('meta')->nullable();
            $table->integer('user_wallet_id')->unsigned();
            $table->timestamps();

            $table->foreign('user_wallet_id','trading_user_wallet_transactions_user_wallet_id_foreign')->references('id')->on('user_wallets')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('user_wallet_transactions', function (Blueprint $table) {
            $table->dropForeign('trading_user_wallet_transactions_user_wallet_id_foreign');
        });

        Schema::dropIfExists('user_wallet_transactions');
    }
}
