<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Query\Expression;

class CreateUserWallets extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_wallets', function (Blueprint $table) {
            $database = DB::connection("mysql_lms")->getDatabaseName();

            $table->integerIncrements('id')->unsigned();
            $table->integer('user_id');
            $table->decimal('balance', 13, 4)->default(0);
            $table->decimal('float_bal', 13, 4)->default(0)->nullable();
            $table->decimal('locked_amount', 13, 4)->default(0)->nullable();
            $table->decimal('credit_limit', 13, 4)->default(0)->nullable();
            $table->timestamps();

            $table->foreign('user_id','trading_user_wallets_user_id_foreign')->references('id')->on(new Expression($database . '.user'))->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('user_wallets', function (Blueprint $table) {
            $table->dropForeign('trading_user_wallets_user_id_foreign');
        });

        Schema::dropIfExists('user_wallets');
    }
}
