<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Query\Expression;

class CreateFarmerProduceAggregation extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('farmer_produce_aggregation', function (Blueprint $table) {
            $database = DB::connection("mysql_lms")->getDatabaseName();

            $table->integerIncrements('id')->unsigned();
            $table->integer('farmer_id');
            $table->integer('produce_item_id')->unsigned();
            $table->integer('quantity')->unsigned();
            $table->decimal('price_per_unit', 13, 4);
            $table->integer('aggregated_by');
            $table->boolean('approved')->default(0);
            $table->integer('approved_by')->nullable();

            $table->timestamps();

            $table->foreign('farmer_id', 'trading_farmer_produce_aggregation_farmer_id_foreign')->references('id')->on(new Expression($database . '.user'))->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('produce_item_id', 'trading_farmer_produce_aggregation_produce_item_id_foreign')->references('id')->on('produce_items')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('aggregated_by', 'trading_farmer_produce_aggregation_aggregated_by_foreign')->references('id')->on(new Expression($database . '.user'))->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('approved_by', 'trading_farmer_produce_aggregation_approved_by_foreign')->references('id')->on(new Expression($database . '.user'))->onUpdate('CASCADE')->onDelete('RESTRICT');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('farmer_produce_aggregation', function(Blueprint $table)
        {
            $table->dropForeign('trading_farmer_produce_aggregation_farmer_id_foreign');
            $table->dropForeign('trading_farmer_produce_aggregation_produce_item_id_foreign');
            $table->dropForeign('trading_farmer_produce_aggregation_aggregated_by_foreign');
            $table->dropForeign('trading_farmer_produce_aggregation_approved_by_foreign');
        });

        Schema::dropIfExists('farmer_produce_aggregation');
    }
}
