<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateContractDetails extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('contract_details', function (Blueprint $table) {

            $table->integerIncrements('id')->unsigned();
            $table->integer('contract_id')->unsigned();
            $table->integer('produce_item_id')->unsigned();
            $table->integer('tonnage');
            $table->timestamps();

            $table->foreign('contract_id','trading_contract_details_contract_id_foreign')->references('id')->on('trader_contracts')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('produce_item_id','trading_contract_details_produce_item_id_foreign')->references('id')->on('produce_items')->onUpdate('CASCADE')->onDelete('RESTRICT');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('contract_details', function (Blueprint $table) {
            $table->dropForeign('trading_contract_details_contract_id_foreign');
            $table->dropForeign('trading_contract_details_produce_item_id_foreign');
        });

        Schema::dropifExists('contract_details');
    }
}
