<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTraderContracts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('trader_contracts', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->integer('trader_id')->unsigned();
            $table->string('name')->nullable();
            $table->string('contract_file')->nullable();
            $table->integer('produce_id')->unsigned();
            $table->integer('produce_unit_id')->unsigned();
            $table->decimal('price_per_unit', 13, 4);
            $table->integer('tonnage');
            $table->boolean('active')->default(1);
            $table->timestamps();

            $table->foreign('trader_id','trading_trader_contracts_trader_id_foreign')->references('id')->on('traders')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('produce_id','trading_trader_contracts_produce_id_foreign')->references('id')->on('produce')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('produce_unit_id','trading_trader_contracts_produce_unit_id_foreign')->references('id')->on('produce_units')->onUpdate('CASCADE')->onDelete('RESTRICT');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('trader_contracts', function (Blueprint $table) {
            $table->dropForeign('trading_trader_contracts_trader_id_foreign');
        });

        Schema::dropifExists('trader_contracts');
    }
}
