<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Query\Expression;

class CreateTraderContacts extends Migration
{
   /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('trader_contacts', function (Blueprint $table) {
            $database = DB::connection("mysql_lms")->getDatabaseName();

            $table->integerIncrements('id')->unsigned();
            $table->integer('trader_id')->unsigned();
            $table->string('firstname')->nullable();
            $table->string('lastname')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->integer('user_id')->nullable();
            $table->boolean('is_admin')->default(0);
            $table->timestamps();

            $table->foreign('trader_id','trading_trader_contacts_trader_id_foreign')->references('id')->on('traders')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('user_id','trading_trader_contacts_user_id_foreign')->references('id')->on(new Expression($database . '.user'))->onUpdate('CASCADE')->onDelete('SET NULL');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('trader_contacts', function (Blueprint $table) {
            $table->dropForeign('trading_trader_contacts_trader_id_foreign');
            $table->dropForeign('trading_trader_contacts_user_id_foreign');
        });

        Schema::dropifExists('trader_contacts');
    }
}
