<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInputItems extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('input_items', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->integer('trader_id')->unsigned();
            $table->integer('input_id')->unsigned();
            $table->integer('input_unit_id')->unsigned();
            $table->float('price_per_unit');
            $table->boolean('listed')->default('1');
            $table->string('name')->nullable();
            $table->string('icon')->nullable();
            $table->timestamps();

            $table->foreign('trader_id','trading_input_items_trader_id_foreign')->references('id')->on('traders')->onDelete('cascade');
            $table->foreign('input_id','trading_input_items_input_id_foreign')->references('id')->on('input')->onDelete('cascade');
            $table->foreign('input_unit_id','trading_input_items_input_unit_id_foreign')->references('id')->on('input_units');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::table('input_items', function (Blueprint $table) {
            $table->dropForeign('trading_input_items_trader_id_foreign');
            $table->dropForeign('trading_input_items_input_id_foreign');
		    $table->dropForeign('trading_input_items_input_unit_id_foreign');
        });

        Schema::dropifExists('input_items');
    }
}
