<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInput extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('input', function (Blueprint $table) {

            $table->integerIncrements('id')->unsigned();
            $table->integer('category_id')->unsigned();
            $table->string('name');
            $table->text('description');
            $table->boolean('listed');
            $table->string('icon')->nullable();
            $table->timestamps();

            $table->foreign('category_id','trading_input_category_id_foreign')->references('id')->on('input_categories')->onUpdate('CASCADE')->onDelete('RESTRICT');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::table('input', function (Blueprint $table) {
            $table->dropForeign('trading_input_category_id_foreign');

        });

        Schema::dropifExists('input');
    }
}
