<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInputCategories extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('input_categories', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->string('name');
            $table->string('description');
            $table->integer('parent_id')->unsigned()->nullable();
            $table->timestamps();

            $table->foreign('parent_id','trading_input_parent_id_foreign')->references('id')->on('input_categories')->onUpdate('CASCADE')->onDelete('RESTRICT');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('input_categories', function(Blueprint $table)
		{
            $table->dropForeign('trading_input_parent_id_foreign');
        });

        Schema::dropIfExists('input_categories');
    }
}
