<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Query\Expression;

class CreateTraderMember extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trader_members', function (Blueprint $table) {
            $database = DB::connection("mysql_lms")->getDatabaseName();

            $table->integerIncrements('id')->unsigned();
            $table->integer('user_id');
            $table->integer('trader_id')->unsigned();
            $table->boolean('active')->default(1);
            $table->timestamps();

            $table->foreign('user_id', 'trading_trader_members_user_id_foreign')->references('id')->on(new Expression($database . '.user'))->onUpdate('CASCADE')->onDelete('RESTRICT');
			$table->foreign('trader_id', 'trading_trader_members_trader_id_foreign')->references('id')->on('traders')->onUpdate('CASCADE')->onDelete('RESTRICT');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('trader_members', function(Blueprint $table)
        {
            $table->dropForeign('trading_trader_members_user_id_foreign');
            $table->dropForeign('trading_trader_members_trader_id_foreign');
        });

        Schema::dropIfExists('trader_members');
    }
}
