<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Query\Expression;

class CreateStocks extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('stocks', function (Blueprint $table) {
            $database = DB::connection("mysql_lms")->getDatabaseName();

            $table->integerIncrements('id')->unsigned();
            $table->integer('produce_item_id')->unsigned();
            $table->integer('farmer_id');
            $table->float('price');
            $table->float('amount');
            $table->string('description');
            $table->timestamps();

            $table->foreign('farmer_id','trading_stocks_farmer_id_foreign')->references('id')->on(new Expression($database . '.user'))->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('produce_item_id','trading_stocks_produce_item_id_foreign')->references('id')->on('produce_items')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {

        Schema::table('stocks', function(Blueprint $table)
		{
            $table->dropForeign('trading_stocks_farmer_id_foreign');
            $table->dropForeign('trading_stocks_produce_item_id_foreign');
		});

		Schema::drop('stocks');
    }

}
